#!/usr/bin/python
#
""" subscribe to a ProctoLogic server channel and receive data.
 based on replyOSC.py by daniel holth and clinton mcchesney

 usage: wtClient.py wireTAPhost hostport receiveport channel

 author: michael branton

 This script is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this script; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 uses danny holth/clinton mcchesney OSC.py module to convert data into 
 OSC format http://wiretap.stetson.edu"""

from wtMessenger import wtMessenger
import struct
import math
import sys

# check arg count
if len(sys.argv) < 4:
        print 'usage: wtClient.py wireTAPhost hostport receiveport channel' 
        sys.exit(1)

# parse args
host    = sys.argv[1]
port    = int(sys.argv[2])
myport	= int(sys.argv[3])
channel = sys.argv[4]

# build and send channel subscription message
mess=wtMessenger()
mess.setServerPort(port)
mess.setClientPort(myport)
mess.serverConnect(host,channel)
mess.subscribe()
# receive channel data
while 1:
	try:
		rec=[]
		mess.receive(rec)
		for datum in rec:
   			print datum

	except KeyboardInterrupt:
		#mess.unsubscribe()
		mess.serverDisconnect()
                print ' '
                print 'your channel session is now complete'
                print ' '
                sys.exit(0)
