#!/usr/bin/python
#
# sendOSC.py
#
# A little program to send OSC messages over UDP.
# Sends messages that include typetags.
#
# Daniel Holth

import socket
import struct
import math
import sys
from OSC import *

s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

def send(host, message):
    HOST = host
    PORT = 4950
    #PORT = 22
    
    print s.sendto(message, (HOST, PORT))


# Returns a list of properly (as far as we can tell)
# parsed arguments.  Strings get converted
def parseArgs(args):    
    parsed = []
    for arg in args:
        print arg
        #arg = arg.strip()
        interpretation = None
        
        try:
            interpretation = float(arg)
            if interpretation == math.ceil(interpretation):
                interpretation = int(interpretation)
        except:
            # Oh - it was a string.
            interpretation = arg
            pass
        parsed.append(interpretation)
    return parsed


if __name__ == "__main__":
    message = OSCMessage()
    
    parsed = parseArgs(sys.argv[2:])
    print parsed
    message.setAddress(parsed[0])

    for i in parsed[1:]:
        message.append(i)

    print hexDump(repr(message))
    
    send(sys.argv[1],message.getBinary())
