#!/usr/bin/python
#
# A sample input client in python.
#
# Reads lines of input from the user, sending them
# to the OSC server and address specified on the
# command line.
#
# Daniel Holth
# 10 May, 2002

import OSC
import socket
import sys

def usage():
    usage = """    
Usage: %s [option]* hostname address

hostname:   The dotted-decimal IP address or
            hostname of the target machine.

address:    OSC address of the messages that will
            be sent.

Options:
            -p /integer/\tset the port to transmit on

""" % sys.argv[0]
    sys.stdout.write(usage)


def run(remote, address):
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

    print "sending lines to", remote, "(osc: %s)" % address

    message = "foo"
    while message != None:
        try:
            message = raw_input()
        except EOFError, e:
            print "bye..."
            sys.exit(0)

        osc = OSC.OSCMessage()
        osc.setAddress(address)
        osc.append(message)

        data = osc.getBinary()
        s.sendto(data, remote)


if __name__ == "__main__":
    arguments = sys.argv[1:]
    arguments.reverse()

    port        = 4950
    hostname    = None
    address     = "/print"

    while arguments:
        argument = arguments.pop()
        if argument == "-p":
            try:
                port = arguments.pop()
                port = int(port)
            except:
                sys.stdout.write("Error getting port number")
                usage()
                raise
        elif argument in ("--help", "-h"):
            usage()
            sys.exit()
        elif hostname == None:
            hostname = argument
        else:
            address = argument
            

    if port == None:
        print "Please give a port number."
    if hostname == None:
        print "Please give a hostname."
    if address == None:
        print "Please give an address."

    if None in (address, hostname, port):
        usage()
        sys.exit()
     
    run((hostname, port), address)
