#!/usr/bin/python
#
# send successive generations of the cellular automaton described
# by rule 30  to ProctoLogic server (see, for example,
# http://mathworld.wolfram.com/ElementaryCellularAutomaton.html)
#
# usage: rule30client.py host port address CAsize
#
# author: michael branton
#
# This script is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this script; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# uses danny holth/clinton mcchesney OSC.py module to convert data into OSC format
# http://galatea.stetson.edu/~ProctoLogic/

# modified by ZhiChao Zheng on 10/11/02


import commProcto
import sys
import os
from operator import *
from OSC import *
import random
import time

# check arg count
if len(sys.argv) < 6:
	print 'usage:  randomFloat.py host port address min max'
	sys.exit(1)

# parse args
host	= sys.argv[1]
port	= int(sys.argv[2])
address = sys.argv[3]
min	= int(sys.argv[4])
max	= int(sys.argv[5])
if len(sys.argv) == 7:
	freq = int(sys.argv[6])
else:
	freq = 0.5


# create communication socket
s=commProcto.create(0)

# calculate CA generations and ship them off
while 1:
	try:
                message = OSCMessage()
                message.setAddress(address)
                message.append(random.random()*max+min)
               	#print "Sending %s %d %s %s " % (host, port, address, currentCA[0:SIZE])
                commProcto.send(s,host,port,message.getBinary())
		time.sleep(freq)

        except KeyboardInterrupt:
                print ' '
                print 'your CA session is now complete'
                print ' '
                sys.exit(0)
