#!/usr/bin/python
"""Waits on port 4950, ready to decode any OSC packets that come its
way."""

import sys
import socket
import OSC


def getOSC(port):
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.bind(('', port))

    while 1:
        data, address = s.recvfrom(1024)
        print address
        OSC.hexDump(data)
        print OSC.decodeOSC(data)


if __name__ == "__main__":
    port = 4950
    helpArguments = ('--help', '-h', '-help')

    help = """%s

Listens for OSC packets, decoding and printing
them as they arrive.

Usage:
    %s [port]
    (port defaults to %d)\n""" % (sys.argv[0], sys.argv[0], port)
    
    if len(sys.argv) >= 2:
        if sys.argv[1] in helpArguments:
            print help
            sys.exit(0)
            
        try:
            port = int(sys.argv[1])
        except:
            print help
            sys.exit(0)

    getOSC(port)
