#!/usr/bin/python2
#
"""dna data client for  Python

author: michael branton

usage: dnaClient.py wireTAPhost port wireTAPchannel start stop {debug}

this connects you to www.ncbi.nlm.nih.gov/entrez/, from
which dna sequences may be downloaded. currently, the sequence
chosen is hardcoded, but you may set the start and stop points
in the sequence. specifying any value at all for the debug parameter
causes the data to also be dumped to the screen

This script is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this script; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


uses danny holth/clinton mcchesney OSC.py module to convert data into 
OSC format and the wireTAP API. see http://wireTAP.stetson.edu
"""

from wtMessenger import wtMessenger
import sys
import os
from time import sleep

# sleep time (in seconds)
SLEEP=.01

# check arg count
if len(sys.argv) < 5:
	print 'usage:  dnaClient.py wireTAPhost port wireTAPchannel start stop {debug}'
	sys.exit(1)

# parse args
host	= sys.argv[1]
port	= int(sys.argv[2])
channel = sys.argv[3]
start   = sys.argv[4]
stop    = sys.argv[5] 
if len(sys.argv) > 6:
	DEBUG='true'
else:
	DEBUG=''

# create connection to wireTAP server
mess=wtMessenger()
mess.setServerPort(int(port))
mess.serverConnect(host,channel)

# run wget to connect to nih website
dnadumpcmd = 'wget -O - http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi\?val=NT_034471.1\&from='+start+'\&to='+stop+'\&txt=on\&view=fasta'

print "executing "+dnadumpcmd+"\n"

while 1:

	a = os.popen(dnadumpcmd)

	# read dna data and send it to the server
	q = a.readline()
	while q!='':
        	try:

                	q = a.readline()        # read dnadump data
			if DEBUG:
                		print 'dnadump:', q

			mess.add(q)

                	# ship it off
			mess.send()

			sleep(SLEEP)

        	except KeyboardInterrupt:
			mess.serverDisconnect()
                	print ' '
                	print 'your dnadump session is now complete'
                	print ' '
                	sys.exit(0)

mess.serverDisconnect()
