#!/usr/bin/python2
#
"""carnivore client for Python
 
 author: michael branton

 usage: carnivoreClient.py wireTAPhost port wireTAPchannel 
                           carnivorehost port wraplength 
                           sleeptime {debug}

 connects to a specified carnivore server and forwards
 date to a wiretap server.

 This script is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this script; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


 uses danny holth/clinton mcchesney OSC.py module to convert data into OSC format
 http://wireTAP.stetson.edu

 This script is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this script; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""

from wtMessenger import wtMessenger
import sys
import os
import string
from operator import *
from time import sleep
from re import *
from wrap import wrap

# sleep time (in seconds)
SLEEP=.01

# check arg count
if len(sys.argv) < 8:
	print 'usage:  carnivoreClient.py wireTAPhost port wireTAPchannel carnivorehost port wraplength sleeptime {debug}'
	sys.exit(1)

# parse args
WHOST	= sys.argv[1]
WPORT	= sys.argv[2]
CHANNEL = sys.argv[3]
CHOST	= sys.argv[4]
CPORT	= sys.argv[5]
WRAP	= int(sys.argv[6])
SLEEP   = float(sys.argv[7])

if len(sys.argv) > 8:
        DEBUG='true'
else:
        DEBUG=''

# create connection to wireTAP server
mess=wtMessenger()
mess.setServerPort(int(WPORT))
mess.serverConnect(WHOST,CHANNEL)

# run telnet w/ variables
carnivorecmd = 'telnet '+CHOST+' ' + CPORT 
print carnivorecmd
a = os.popen(carnivorecmd)

# read carnivore data and send it to the server
while 1:
        try:
		# read carnivore data
		# we keep the lines short due to a bug
		# in the server which tosses long strings
		q = a.readline()
		if WRAP != 0 :
                	q = wrap(q,WRAP)

                # add data to the message to be sent to the server
		q = q.split('\n')
		for l in q :
			mess.add(l)
			mess.send()
                	if DEBUG :
                        	print len(l)
                        	print '***'+l+'***'

		sleep(SLEEP)

        except KeyboardInterrupt:

		mess.serverDisconnect()
		a.close();
		
                print ' '
                print 'your carnivore session is now complete'
                print ' '
                sys.exit(0)
