#!/usr/bin/python
#
# sendOSC.py
#
# A little program to send OSC messages over UDP.
# Sends messages that include typetags.
#
# Daniel Holth

import socket
import struct
import math
import sys
from OSC import *

s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

def send(host, message):
    HOST = host
    PORT = 4950
    #PORT = 22
    
    print s.sendto(message, (HOST, PORT))


# Returns a list of properly (as far as we can tell)
# parsed arguments.  Strings get converted
def parseArgs(args):    
    parsed = []
    for arg in args:
        print arg
        #arg = arg.strip()
        interpretation = None
        
        try:
            interpretation = float(arg)
            if interpretation == math.ceil(interpretation):
                interpretation = int(interpretation)
        except:
            # Oh - it was a string.
            interpretation = arg
            pass
        parsed.append(interpretation)
    return parsed


if __name__ == "__main__":
    
    print1 = OSCMessage()
    print1.setAddress("/print")
    print1.append("Hey man, that's cool.")
    print1.append(42)
    print1.append(3.1415926)
   
    int1 = OSCMessage()
    int1.setAddress("/in/int")
    int1.append(42)

    int2 = OSCMessage()
    int2.setAddress("/in/int")
    int2.append(84)

    # currently, the nested bundle is detected by the OSCBundleHandler
    # if there is one print1.getBinary() appended, but not if there are two.
    # dwh 12 Nov. 2002

    bundle = OSCMessage()
    bundle.setAddress("")
    bundle.append("#bundle")
    bundle.append(0)
    bundle.append(0)
    bundle.append(print1.getBinary(), 'b')
    bundle.append(print1.getBinary(), 'b')
    bundle.append(int1.getBinary(), 'b')
    bundle.append(int2.getBinary(), 'b')
    bundle.append(bundle.message, 'b')

    bundlebinary = bundle.message
    
    hexDump(bundlebinary)

    send(sys.argv[1], bundlebinary)
