#!/usr/bin/python
#
"""add a new channel to a wireTAP server

 author: michael branton

 usage: addChannel.py wireTAPhost port channel description

 This script is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this script; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 uses danny holth/clinton mcchesney OSC.py module to convert data into OSC format
 and the python wireTAP API
 http://wiretap.stetson.edu/
"""

from wtMessenger import wtMessenger
import sys
import os
import re

# check arg count
if len(sys.argv) < 5:
	print 'usage:  addChannel.py wireTAPhost port channel description'
	sys.exit(1)

# parse args
host	= sys.argv[1]
port	= int(sys.argv[2])
channel = sys.argv[3]
description = sys.argv[4]

# create connection to wireTAP server
mess=wtMessenger()
mess.setServerPort(port)
mess.serverConnect(host)

# add channel
mess.addChannel(channel,description)

sys.exit(0)
